<?php
/* --------------------------------------------------------------
 GoogleServiceProvider.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace GXModules\Gambio\Google\Admin\Plugin;

use Doctrine\DBAL\Connection;
use Gambio\Core\Application\ValueObjects\Path;
use Gambio\Core\Application\ValueObjects\Url;
use Gambio\Core\Application\Plugins\Abstraction\AbstractPluginServiceProvider;
use Gambio\Core\Language\TextManager;

/**
 * Class GoogleServiceProvider
 * @package GXModules\Gambio\Google\Admin
 */
class GoogleServiceProvider extends AbstractPluginServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [GoogleLoadLayoutDataHandler::class];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->share(GoogleLoadLayoutDataHandler::class)->addArgument(GoogleFooterBadgeLoader::class);
        $this->application->share(GoogleFooterBadgeLoader::class)->addArgument(Connection::class)->addArgument(
                TextManager::class
            )->addArgument(Url::class)->addArgument(Path::class);
    }
}